/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.ws.api.uddi.WSBindingTemplate;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.service.BusinessService;

public class WSBusinessService {
    private WSUDDIRegistry m_uddiRegistry = null;
    private WSBusinessEntity m_businessEntity = null;
    private BusinessService m_businessService = null;
    private Vector m_bindingTemplates = null;
    private CategoryBag m_categoryBag = null;
    private Vector m_categoryVector = null;

    public WSBusinessService(WSUDDIRegistry uddiRegistry, WSBusinessEntity businessEntity, BusinessService businessService) {
        this.m_businessEntity = businessEntity;
        this.m_uddiRegistry = uddiRegistry;
        this.m_businessService = businessService;
    }

    public WSBusinessEntity getBusinessEntity() {
        return this.m_businessEntity;
    }

    public String getName() {
        Vector v;
        if (this.m_businessService != null && (v = this.m_businessService.getNameVector()) != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
            return ((Name)v.get(0)).getValue();
        }
        return null;
    }

    public String getDescription() {
        Vector v;
        if (this.m_businessService != null && (v = this.m_businessService.getDescriptionVector()) != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
            return ((Description)v.get(0)).getValue();
        }
        return null;
    }

    public String getBusinessKey() {
        if (this.m_businessService != null) {
            return this.m_businessService.getBusinessKey();
        }
        return null;
    }

    public String getServiceKey() {
        if (this.m_businessService != null) {
            return this.m_businessService.getServiceKey();
        }
        return null;
    }

    public Vector getCategories() throws Exception {
        if (this.m_categoryVector == null && this.m_categoryBag == null && this.m_businessService != null) {
            this.m_categoryBag = this.m_businessService.getCategoryBag();
            this.m_categoryVector = this.m_categoryBag.getKeyedReferenceVector();
        }
        return this.m_categoryVector;
    }

    private Vector getBindingTemplates() {
        if (this.m_businessService != null && this.m_bindingTemplates == null) {
            this.m_bindingTemplates = new Vector();
            BindingTemplates bindingTemplates = this.m_businessService.getBindingTemplates();
            Vector v = bindingTemplates.getBindingTemplateVector();
            if (v != null && v.size() > 0) {
                for (int i = 0; i < v.size(); ++i) {
                    if (v.get(i) == null || !(v.get(i) instanceof BindingTemplate)) continue;
                    this.m_bindingTemplates.add(new WSBindingTemplate(this.m_uddiRegistry, this, (BindingTemplate)v.get(i)));
                }
            }
        }
        return this.m_bindingTemplates;
    }

    public Vector getTModelKeys() {
        Vector bindingTemplates = this.getBindingTemplates();
        Vector keys = new Vector();
        if (bindingTemplates != null && bindingTemplates.size() > 0) {
            Object obj = null;
            Object bindingTemplate = null;
            for (int i = 0; i < bindingTemplates.size(); ++i) {
                obj = bindingTemplates.get(i);
                if (obj == null || !(obj instanceof WSBindingTemplate)) continue;
                Vector moreKeys = ((WSBindingTemplate)obj).getTModelKeys();
                for (int j = moreKeys.size() - 1; j >= 0; --j) {
                    obj = moreKeys.get(j);
                    if (!keys.contains(obj)) continue;
                    moreKeys.remove(j);
                }
                keys.addAll(moreKeys);
            }
        }
        return keys;
    }

    public WSTModel[] getTModels() throws Exception {
        if (this.m_uddiRegistry != null) {
            return this.m_uddiRegistry.getTModels(this.getTModelKeys());
        }
        return null;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Nov 2005 14:17:04  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }
}

